cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

global type tavg
global distance = 2000

use "crn_only_station_pairs_$distance.dta", clear

su station_pair_id
local max = r(max)

clear
tempfile results
cap gen date = 0
keep if _n < 0
sort date
save "`results'", replace

forvalues pair_id = 1(1)`max' {
	quietly {
	use "crn_only_station_pairs_$distance.dta", clear
	keep if station_pair_id == `pair_id'
	local station_id_1 = station_id_v1[1]
	local station_id_2 = station_id_v2[1]
	local distance = distance[1]
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", clear
	keep if station_id == `station_id_1'
	rename $type crn_1_$type
	gen date = ym(year, month)
	keep crn_1_$type date
	drop if crn_1_$type == . | crn_1_$type == -9999
	sort date
	tempfile crn_1_results
	save "`crn_1_results'", replace
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", clear
	keep if station_id == `station_id_2'
	rename $type crn_2_$type
	gen date = ym(year, month)
	keep crn_2_$type date
	drop if crn_2_$type == . | crn_2_$type == -9999
	sort date
	merge date using "`crn_1_results'"
	keep if _merge == 3
	drop _merge
	sort date
	
	gen month = month(dofm(date))
	gen year = year(dofm(date))

	sort month	
	tempfile tempdata
	save "`tempdata'", replace

	collapse (mean) base_crn_1=crn_1_$type base_crn_2=crn_2_$type, by(month)
	sort month

	merge month using "`tempdata'"
	drop _merge
	replace crn_1_$type = crn_1_$type - base_crn_1
	replace crn_2_$type = crn_2_$type - base_crn_2
	drop base_crn_1 base_crn_2
	
	gen crn_mse =  sum((crn_1_$type - crn_2_$type) ^ 2) / _N
	keep if _n == _N
	keep crn_mse
	gen dataset = "$type"
	gen hcn_id_1 = `station_id_1'
	gen hcn_id_2 = `station_id_2'
	gen pair_id = `pair_id'
	gen distance = `distance'
	gen type = "crn"
	
	append using "`results'"
	save "`results'", replace
	}
	display `pair_id'
}

use "`results'", clear
save "crn_only_mse_diff $type $distance.dta", replace
